/*==============================================================================
* This .do file brings in the UK 1991 Small Area Statistics 
* Data downloaded from NOMIS official labour market statistics 
* http://www.nomisweb.co.uk/
*=============================================================================*/

set more off
clear

cd "$insheet_files/UK"

import excel  "UK_Census_1991_NUTS3", first cellrange(A6:IQ134) 

* Generate Nuts 1 & 2 codes from the NUTS 3 codes  

local sum_var S*

collapse (sum) `sum_var', by(nuts) 

gen nuts_level=3 

tempfile nuts3
save `nuts3.dta'

gen nuts2=substr(nuts,1,4)
	
collapse (sum) `sum_var', by(nuts2) 
	
rename nuts2 nuts
gen nuts_level=2
	
tempfile nuts2
save `nuts2.dta'
	
clear
use `nuts3.dta'
	
gen nuts1=substr(nuts,1,3)

collapse (sum) `sum_var', by(nuts1) 
	
rename nuts1 nuts
gen nuts_level=1

tempfile nuts1
save `nuts1.dta'
	
gen country=substr(nuts,1,2)

collapse (sum) `sum_var', by(country) 
	
rename country nuts
gen nuts_level=0
	
append using `nuts1.dta'	
append using `nuts2.dta'
append using `nuts3.dta'

********************************************************************************

rename S0164 POP

rename S0823Males EMP_males_fulltime
rename S0834 EMP_males_parttime
rename S0845 EMP_males_self_wemployee
rename S0856 EMP_males_self_noemployee

rename S08177 EMP_females_fulltime
rename S08188 EMP_females_parttime
rename S08199 EMP_females_self_wemployee
rename S08210 EMP_females_self_noemployee

rename S0878  UNEMP_males
rename S08232 UNEMP_females

********************************************************************************
egen EMP =rsum(EMP*)
egen UNEMP = rsum(UNEMP*)

gen year = 1991

keep nuts year POP EMP UNEMP

*Report data in thousands
foreach var of varlist POP* EMP* UNEMP* {
	replace `var'=`var'/1000
}

rename POP POP_uk_census_1991 
rename EMP EMP_uk_census_1991
rename UNEMP UNEMP_uk_census_1991
gen LF_uk_census_1991 = EMP_uk_census_1991 + UNEMP_uk_census_1991

********************************************************************************
*NUTS codes are NUTS 2003. Need to convert to NUTS 2010.

*Code change

replace nuts ="UKM5" if nuts=="UKM1"
replace nuts ="UKM6" if nuts=="UKM4"
replace nuts ="UKD72" if nuts=="UKD52"
replace nuts ="UKD73" if nuts=="UKD53"
replace nuts ="UKD74" if nuts=="UKD54"
replace nuts ="UKM50" if nuts=="UKM10"
replace nuts ="UKM61" if nuts=="UKM41"
replace nuts ="UKM62" if nuts=="UKM42"
replace nuts ="UKM63" if nuts=="UKM43"
replace nuts ="UKM64" if nuts=="UKM44"
replace nuts ="UKM65" if nuts=="UKM45"
replace nuts ="UKM66" if nuts=="UKM46"

*Boundary shifts
replace nuts="UKD6" if nuts=="UKD2"
replace nuts="UKD7" if nuts=="UKD5"
replace nuts="UKD61" if nuts=="UKD21"
replace nuts="UKD71" if nuts=="UKD51"

*3) Splits. Create a composite region of NUTS 2010 codes from NUTS 2006 code. 

replace nuts = "UKD62&UKD63" if nuts== "UKD22"
replace nuts = "UKE44&UKE45" if nuts== "UKE43"
replace nuts = "UKF24&UKF25" if nuts== "UKF23"
replace nuts = "UKG36&UKG37" if nuts== "UKG34"
replace nuts = "UKG38&UKG39" if nuts== "UKG35"
replace nuts = "UKH24&UKH25" if nuts== "UKH22"

*****************************************************

save "$dta_files/UK_CENS1991_labor.dta", replace
